function getGroupById(groupId, groups){
  var _group= null;
  groups.forEach(function(group){
    if(group.id === groupId){
      _group = group; return _group;
    }
  });
  return _group;
}

function getTypeFromBulbId(id, bulbs){
  var type="";
  bulbs.forEach(function(bulb){
    if(bulb.id === id){
      type = bulb.type; return type;
    }
  });
  return type;
}

function getBulbsByType(type, idToExclude, bulbs){
  var bulbsType=[];
  var index=0;
  bulbs.forEach(function(bulb){
    if(bulb.type === type){
      if(idToExclude !== null && idToExclude.indexOf(bulb.id) !== -1){ return;}
      bulb.count = index;
      bulbsType.push(bulb);
      index++;
    }
  });
  return bulbsType;
}

function getBulbData(id, bulbs){
  var _bulb=null;
  bulbs.forEach(function(bulb){
    if(id === bulb.id){
      _bulb = bulb; return _bulb;
    }
  });
  return _bulb;
}

/* accepts parameters
 * h  Object = {h:x, s:y, v:z}
 * OR 
 * h, s, v
*/
function HSVtoRGB(h, s, v) {
    var r, g, b, i, f, p, q, t;
    if (h && s === undefined && v === undefined) {
        s = h.s, v = h.v, h = h.h;
    }
    i = Math.floor(h * 6);
    f = h * 6 - i;
    p = v * (1 - s);
    q = v * (1 - f * s);
    t = v * (1 - (1 - f) * s);
    switch (i % 6) {
        case 0: r = v, g = t, b = p; break;
        case 1: r = q, g = v, b = p; break;
        case 2: r = p, g = v, b = t; break;
        case 3: r = p, g = q, b = v; break;
        case 4: r = t, g = p, b = v; break;
        case 5: r = v, g = p, b = q; break;
    }
    return {
        r: Math.floor(r * 255),
        g: Math.floor(g * 255),
        b: Math.floor(b * 255)
    };
}